package com.androidbook.pettracker2;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.androidbook.pettracker2.PetTrackerDatabase.PetType;
import com.androidbook.pettracker2.PetTrackerDatabase.Pets;

//Informacja: Dokładnie to samo co w przykładzie PetTracker.
class PetTrackerDatabaseHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "pet_tracker.db";
    private static final int DATABASE_VERSION = 1;

        
    PetTrackerDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }
 
	@Override
	public void onCreate(SQLiteDatabase db) {
		
		// Utworzenie tabeli gatunków.
		db.execSQL("CREATE TABLE " + PetType.PETTYPE_TABLE_NAME+ " ("
                + PetType._ID + " INTEGER PRIMARY KEY AUTOINCREMENT ,"
                + PetType.PET_TYPE_NAME + " TEXT"
                + ");");
		
		// Utworzenie tabeli zwierzaków
		db.execSQL("CREATE TABLE " + Pets.PETS_TABLE_NAME + " ("
                + Pets._ID + " INTEGER PRIMARY KEY AUTOINCREMENT ,"
                + Pets.PET_NAME + " TEXT,"
                + Pets.PET_TYPE_ID + " INTEGER" // Klucz obcy do tabeli gatunków
                + ");");
	}
	
	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		// Tu aktualizujemy bazę. 
        // Tu należy zaimplementować operację przeniesienia danych
        // ze starej do nowej wersji bazy danych oraz zmianę jej struktury. 
		
	}

	@Override
	public void onOpen(SQLiteDatabase db) {
		super.onOpen(db);
	}
}
